%% Matlab script for Arduino-based accurate distance measurement with Sharp sensors.
%% Written by Philippe Lucidarme
%% http://www.lucidarme.me

close all;
clear all;
clc;

%% Load data from cvs file
RawData=load ('Data_GP2Y0A02YK.csv');

Distance=RawData(:,1);
ADC=RawData(:,2);
Voltage=RawData(:,3);

%% Display data
[AX,H1,H2] = plotyy(Distance,ADC,Distance,Voltage,'plot');
set(get(AX(1),'Ylabel'),'String','ADC Value [0:1023]');
set(get(AX(2),'Ylabel'),'String','Voltage [V]');
set(H1,'LineStyle','-')
set(H2,'LineStyle','.')
xlabel ('Distance [mm]');
grid on;
hold on;



%% Load data from cvs file prepared for approximation

RawData_Ap=load ('Data_GP2Y0A02YK_Ap.csv');

Distance_Ap=RawData_Ap(:,1);
ADC_Ap=RawData_Ap(:,2);
Voltage_Ap=RawData_Ap(:,3);

%% Polynomial approximation
% p1 = polyfit(ADC,Distance,1);
% p2 = polyfit(ADC,Distance,2);
% p3 = polyfit(ADC,Distance,3);
p4 = polyfit(ADC_Ap,Distance_Ap,4)
% f1 = polyval(p1,ADC);
% f2 = polyval(p2,ADC);
% f3 = polyval(p3,ADC);
f4 = polyval(p4,ADC_Ap);

%% Display data and approximation result
figure;
plot (ADC,Distance,'-g','LineWidth',2);
hold on;
plot (ADC_Ap,Distance_Ap,'.','MarkerSize',20);
grid on;
% plot(ADC,f1,'k');
% plot(ADC,f2,'k');
% plot(ADC,f3,'k');
plot(ADC_Ap,f4,'r','LineWidth',2);
xlabel ('ADC');
ylabel ('Distance [mm]');
legend('Real data','Points used for approximation','Approximation');